/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.mossable;

import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.blocks.mossable.Mossable;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface CrackableMossable
extends Mossable,
Crackable {
    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == Mossable.MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        if (weatheringClass == Crackable.CrackLevel.class) {
            return Optional.of(this.getCrackSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(class_2680 state, class_2338 pos, class_1937 level) {
        return Mossable.super.shouldWeather(state, pos, level) || Crackable.super.shouldWeather(state, pos, level);
    }

    @Override
    default public void tryWeather(class_2680 state, class_3218 serverLevel, class_2338 pos, class_5819 random) {
        if (random.method_43057() < this.getWeatherChanceSpeed()) {
            boolean isMoss = this.getMossSpreader().getWantedWeatheringState(true, pos, (class_1937)serverLevel);
            Optional<Object> opt = Optional.empty();
            if (isMoss) {
                opt = this.getNextMossy(state);
            } else if (this.getCrackSpreader().getWantedWeatheringState(true, pos, (class_1937)serverLevel)) {
                opt = this.getNextCracked(state);
            }
            class_2680 newState = opt.orElse((class_2680)state.method_11657(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)));
            if (newState != state) {
                serverLevel.method_8652(pos, newState, 2);
                if (!newState.method_28498(Weatherable.WEATHERABLE)) {
                    serverLevel.method_39279(pos, state.method_26204(), 1);
                }
            }
        }
    }
}

